% Copyright 2014 Sandia Corporation. Under the terms of Contract DE-AC04-94AL85000 with Sandia
% Corporation, the U.S. Government retains certain rights in this software
%
% This file is part of Sandia SPT (Sandia Simple Particle Tracking) v. 1.0.
% 
% Sandia SPT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
% 
% Sandia SPT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with Sandia SPT.  If not, see <http://www.gnu.org/licenses/>.

function display3D(trajectories,minLength)

%function display3D(trajectories,minLength)
%
%PURPOSE:
%	display3D.m is designed to display trajectories. 
%
%DEPENDENCIES:
%	-None-
%
%INPUTS:
%	costMat:
%		The cost matrix. Entries which should not be considered as possible
%		solutions should be replaced with NaN's. From lapjv.m, "the (i,j)th
%		element represents the cost to assign the jth job to the ith 
%		worker.
%	resolution: (optional)
%		See lapjv.m
%
%OUTPUTS:
%	trajectories:
%		Each row corresponds to a signal detected in a frame. The first
%		two columns correspond to the x and y coordinates respectively 
%		(in units of pixels). The third column corresponds to the frame
%		number in which that signal was detected. The fourth column
%		corresponds to the ID of the trajectory to which this observation
%		belongs. Each trajectory has a unique ID, with the exception of
%		those entries for which this value is 0. Rows whose fourth column
%		values are 0 correspond to observations which do not belong to any
%		trajectory, but are isolated points. 
%	minLength:
%		Only trajectories longer than this will be displayed. 
%
%REFERENCES:
%	-None-
%
%LIMITATIONS:
%	Written for a specific purpose, and not generalized. 
%
%NOTES:
%	-None-
%
%Written by Stephen M. Anthony 08/26/2014
%Last modified on 08/26/14 by Stephen M. Anthony

%Sort into trajectory order
sorted = sortrows(trajectories,[4 3]);

%Determine the multiplicity of each trajectory
[~,first] = unique(sorted(:,4));
multiplicity = diff([first; size(trajectories,1)+1]);

%Separate trajectories into cells
trajCell = mat2cell(sorted,multiplicity,4);

%Create a 3D plot of the points which were not placed into trajectories
%plot3(trajCell{1}(:,1),trajCell{1}(:,2),trajCell{1}(:,3),'rx')

%Eliminate the first entry as non-tracked
trajCell = trajCell(2:end);
multiplicity = multiplicity(2:end);

%Keep only those trajectories longer than the minimum length
keep = multiplicity >=minLength;
trajCell = trajCell(keep);


for j=1:numel(trajCell)
	clf
	x = trajCell{j}(:,1)';
	y = trajCell{j}(:,2)';
	z = zeros(size(x));
	col = trajCell{j}(:,3)';  % This is the color, vary with x in this case.
	
	surface([x;x],[y;y],[z;z],[col;col],...
		'facecol','no',...
		'edgecol','interp',...
		'linew',2);
% 	line(trajCell{j}(:,1),trajCell{j}(:,2),trajCell{j}(:,3),'LineWidth',2,'Color','b')
	pause
end
%axis([0 215 0 192 0 401])
